#include <avr/io.h>
#include <avr/interrupt.h>
#include "CCJEncoder.h"

// Interrupt based encoder class
// Each instance needs its own specialized version that cannot be shared.
// So declare each encoder with its own type: CCJISREncoder<1>, CCJISREncoder<2>, CCJISREncoder<3>, etc.
CCJISREncoder<1> encoder1;
//CCJISREncoder<2> encoder2;
//CCJISREncoder<3> encoder3;

// Polling based encoder class.
//CCJPollEncoder encoder1;
CCJPollEncoder encoder2;
//CCJPollEncoder encoder2;

void setup() 
{
    Serial.begin(9600);
    encoder1.init(2, 3);
    encoder2.init(4, 5);
}

void loop() 
{
    if (encoder1.check())
    {
        Serial.print("Value1: ");
        Serial.println(encoder1.value());
    }

    if (encoder2.check())
    {
        Serial.print("Value2: ");
        Serial.println(encoder2.value());
    }    
}
